% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redirect.R
\name{redirect}
\alias{redirect}
\title{redirect}
\usage{
redirect(type, target, linkOthers = TRUE, local = TRUE)
}
\arguments{
\item{type}{Dataset name, e.g. "Tau" for \code{\link{readTau}}}

\item{target}{Either path to the new source folder that should be used instead of the default,
or NULL to remove the redirection, or a vector of paths to files which are then symlinked
into a temporary folder that is then used as target folder; if the vector is named the names
are used as relative paths in the temporary folder, e.g. target = c(`a/b/c.txt` = "~/d/e/f.txt")
would create a temporary folder with subfolders a/b and there symlink c.txt to ~/d/e/f.txt.}

\item{linkOthers}{If target is a list of files, whether to symlink all other files in the original
source folder to the temporary folder.}

\item{local}{The scope of the redirection, passed on to setConfig. Defaults to the current function.
Set to an environment for more control or to FALSE for a permanent/global redirection.}
}
\value{
Invisibly, the source folder that is now used for the given type
}
\description{
Redirect a given dataset type to a different source folder.
The redirection is local, so it will be reset when the current function call returns. See
example for more details.
}
\examples{
\dontrun{
f <- function() {
  redirect("Tau", target = "~/TauExperiment")
  # the following call will change directory
  # into ~/TauExperiment instead of <getConfig("sourcefolder")>/Tau
  readSource("Tau")
}
f()
# Tau is only redirected in the local environment of f,
# so it will use the usual source folder here
readSource("Tau")
}
}
\author{
Pascal Sauer
}
