% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_group_split}
\alias{data_dict_group_split}
\title{Split grouped data dictionaries into a named list}
\usage{
data_dict_group_split(data_dict, ...)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
transformed.}

\item{...}{Column in the data dictionary to split it by. If not provided, the
splitting will be done on the grouping element of a grouped data dictionary.}
}
\value{
A list of data frame(s) identifying a list of workable data dictionary structure.
}
\description{
Divides data dictionary element(s) into the groups defined by the query.
This function divides both the 'Variables' and 'Categories' elements (if
the group exists under the same definition in in both) into a list of
data dictionaries, each with the rows of the associated group and all the
original columns, including grouping variables. This function is analogous
to running \code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:group_split]{dplyr::group_split()}}. Each element is
named using the group values. \code{\link[=data_dict_list_nest]{data_dict_list_nest()}} reverses the effect.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

data_dict_list <- list(
  data_dict_1 = madshapR_examples$`data_dictionary_example - collapsed`,
  data_dict_2 = madshapR_examples$`data_dictionary_example` )

data_dict_ns <-
  data_dict_list_nest(data_dict_list, name_group = "table") \%>\%
  data_dict_group_by(col = "table")
  
data_dict_sp <- data_dict_group_split(data_dict_ns,col = "table")

glimpse(data_dict_sp)
 
}

}
\seealso{
\code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{\link[dplyr:group_split]{dplyr::group_split()}} ,
\code{\link[=data_dict_group_by]{data_dict_group_by()}}, \code{\link[=data_dict_list_nest]{data_dict_list_nest()}}
}
