% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{is_data_dict_shape}
\alias{is_data_dict_shape}
\title{Test if an object is a workable data dictionary structure}
\usage{
is_data_dict_shape(object)
}
\arguments{
\item{object}{A potential data dictionary structure to be evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input object has adequate structure to work with functions
involving data dictionary shaping. This function mainly helps validate input
within other functions of the package but could be used to check if an
object is valid for use in a function.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

# use madshapR_examples provided by the package
is_data_dict_shape(madshapR_examples$`data_dictionary_example - errors`)
is_data_dict_shape(madshapR_examples$`data_dictionary_example - errors with data`)
is_data_dict_shape(madshapR_examples$`data_dictionary_example`)
is_data_dict_shape(iris)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
