% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{typeof_convert_to_valueType}
\alias{typeof_convert_to_valueType}
\title{Convert typeof (and class if any) into its corresponding valueType}
\usage{
typeof_convert_to_valueType(typeof, class = NA_character_)
}
\arguments{
\item{typeof}{A string representing the type to be converted.
Supported values include "character", "integer", "double", "logical".}

\item{class}{An optional parameter that specifies a class context.
If provided, the function may return a more refined value type based on the
class type; if not, the function will return a general equivalent.
Supported values include "character", "integer","numeric","logical","Date"
and "POSIXct". NULL is the default.}
}
\value{
A character vector, named 'valueType'.
}
\description{
The function converts a given typeof string into its corresponding valueType
representation. This function is particularly useful for mapping different
data types to their equivalent value types in contexts such as data modeling
and data dictionary creation. An optional class parameter allows for more
specific conversions when necessary.
}
\details{
The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

typeof_convert_to_valueType(typeof = "character")
typeof_convert_to_valueType(typeof = "double")
typeof_convert_to_valueType(typeof = "double", class = "Date")

}

}
