% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphology.R
\name{morphology}
\alias{morphology}
\alias{image_morphology}
\alias{image_convolve}
\title{Morphology}
\usage{
image_morphology(
  image,
  method = "convolve",
  kernel = "Gaussian",
  iterations = 1,
  opts = list()
)

image_convolve(
  image,
  kernel = "Gaussian",
  iterations = 1,
  scaling = NULL,
  bias = NULL
)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{method}{a string with a valid method from \code{\link[=morphology_types]{morphology_types()}}}

\item{kernel}{either a square matrix or a string. The string can either be a
parameterized \link[=kernel_types]{kerneltype} such as: \code{"DoG:0,0,2"} or \code{"Diamond"}
or it can contain a custom matrix (see examples)}

\item{iterations}{number of iterations}

\item{opts}{a named list or character vector with custom attributes}

\item{scaling}{string with kernel scaling. The special flag \code{"!"} automatically scales to full
dynamic range, for example: \code{"50\%!"}}

\item{bias}{output bias string, for example \code{"50\%"}}
}
\description{
Apply a morphology method. This is a very flexible function which
can be used to apply any morphology method with custom parameters.
See \href{https://legacy.imagemagick.org/Usage/morphology/}{imagemagick website}
for examples.
}
\examples{
#example from IM website:
if(magick_config()$version > "6.8.8"){
pixel <- image_blank(1, 1, 'white') |> image_border('black', '5x5')

# See the effect of Dilate method
pixel |> image_scale('800\%')
pixel |> image_morphology('Dilate', "Diamond") |> image_scale('800\%')

# These produce the same output:
pixel |> image_morphology('Dilate', "Diamond", iter = 3) |> image_scale('800\%')
pixel |> image_morphology('Dilate', "Diamond:3") |> image_scale('800\%')

# Plus example
pixel |> image_morphology('Dilate', "Plus", iterations = 2) |> image_scale('800\%')

# Rose examples
rose |> image_morphology('ErodeI', 'Octagon', iter = 3)
rose |> image_morphology('DilateI', 'Octagon', iter = 3)
rose |> image_morphology('OpenI', 'Octagon', iter = 3)
rose |> image_morphology('CloseI', 'Octagon', iter = 3)

# Edge detection
man <- demo_image('man.gif')
man |> image_morphology('EdgeIn', 'Octagon')
man |> image_morphology('EdgeOut', 'Octagon')
man |> image_morphology('Edge', 'Octagon')

# Octagonal Convex Hull
 man |>
   image_morphology('Close', 'Diamond') |>
   image_morphology('Thicken', 'ConvexHull', iterations = 1)

# Thinning down to a Skeleton
man |> image_morphology('Thinning', 'Skeleton', iterations = 1)

# Specify custom kernel matrix usingn a string:
img <- demo_image("test_mag.gif")
i <- image_convolve(img, kernel = '4x5:
       0 -1  0  0
      -1 +1 -1  0
      -1 +1 -1  0
      -1 +1 +1 -1
       0 -1 -1  0 ', bias = "50\%")
}
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
