% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-custom.R
\name{llm_custom}
\alias{llm_custom}
\alias{llm_vec_custom}
\title{Send a custom prompt to the LLM}
\usage{
llm_custom(.data, col, prompt = "", pred_name = ".pred", valid_resps = "")

llm_vec_custom(x, prompt = "", valid_resps = NULL)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{prompt}{The prompt to append to each record sent to the LLM}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{valid_resps}{If the response from the LLM is not open, but
deterministic, provide the options in a vector. This function will set to
\code{NA} any response not in the options}

\item{x}{A vector that contains the text to be analyzed}
}
\value{
\code{llm_custom} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_custom} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to process the provided text using the
instructions from \code{prompt}
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

my_prompt <- paste(
  "Answer a question.",
  "Return only the answer, no explanation",
  "Acceptable answers are 'yes', 'no'",
  "Answer this about the following text, is this a happy customer?:"
)

reviews |>
  llm_custom(review, my_prompt)
}
}
