/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.GreedyAgglomerative;
import cc.mallet.cluster.neighbor_evaluator.NeighborEvaluator;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.pipe.Pipe;
import cc.mallet.util.MalletProgressMessageLogger;
import com.carrotsearch.hppc.IntArrayList;
import java.util.Random;
import java.util.logging.Logger;

public class GreedyAgglomerativeByDensity
extends GreedyAgglomerative {
    private static final long serialVersionUID = 1L;
    private static Logger progressLogger = MalletProgressMessageLogger.getLogger(GreedyAgglomerativeByDensity.class.getName() + "-pl");
    boolean doPostConvergenceMerges;
    IntArrayList unclusteredInstances;
    int instanceBeingClustered;
    Random random;

    public GreedyAgglomerativeByDensity(Pipe instancePipe, NeighborEvaluator evaluator, double stoppingThreshold, boolean doPostConvergenceMerges, Random random) {
        super(instancePipe, evaluator, stoppingThreshold);
        this.doPostConvergenceMerges = doPostConvergenceMerges;
        this.random = random;
        this.instanceBeingClustered = -1;
    }

    @Override
    public boolean converged(Clustering clustering) {
        return this.converged;
    }

    @Override
    public void reset() {
        super.reset();
        this.unclusteredInstances = null;
        this.instanceBeingClustered = -1;
    }

    @Override
    public Clustering improveClustering(Clustering clustering) {
        if (this.instanceBeingClustered == -1) {
            this.sampleNextInstanceToCluster(clustering);
        }
        int clusterIndex = clustering.getLabel(this.instanceBeingClustered);
        double bestScore = Double.NEGATIVE_INFINITY;
        int clusterToMerge = -1;
        int instanceToMerge = -1;
        for (int i = 0; i < this.unclusteredInstances.size(); ++i) {
            int neighbor = this.unclusteredInstances.get(i);
            int neighborCluster = clustering.getLabel(neighbor);
            double score = this.getScore(clustering, clusterIndex, neighborCluster);
            if (!(score > bestScore)) continue;
            bestScore = score;
            clusterToMerge = neighborCluster;
            instanceToMerge = neighbor;
        }
        if (bestScore < this.stoppingThreshold) {
            this.sampleNextInstanceToCluster(clustering);
            if (this.instanceBeingClustered != -1 && this.unclusteredInstances.size() != 0) {
                return this.improveClustering(clustering);
            }
            if (this.doPostConvergenceMerges) {
                throw new UnsupportedOperationException("PostConvergenceMerges not yet implemented.");
            }
            this.converged = true;
            progressLogger.info("Converged with score " + bestScore);
        } else {
            progressLogger.info("Merging " + clusterIndex + "(" + clustering.size(clusterIndex) + " nodes) and " + clusterToMerge + "(" + clustering.size(clusterToMerge) + " nodes) [" + bestScore + "] numClusters=" + clustering.getNumClusters());
            this.updateScoreMatrix(clustering, clusterIndex, clusterToMerge);
            this.unclusteredInstances.remove(this.unclusteredInstances.indexOf(instanceToMerge));
            clustering = ClusterUtils.mergeClusters(clustering, clusterIndex, clusterToMerge);
        }
        return clustering;
    }

    private void sampleNextInstanceToCluster(Clustering clustering) {
        if (this.unclusteredInstances == null) {
            this.fillUnclusteredInstances(clustering.getNumInstances());
        }
        this.instanceBeingClustered = this.unclusteredInstances.size() == 0 ? -1 : this.unclusteredInstances.remove(0);
    }

    private void fillUnclusteredInstances(int size) {
        int i;
        int[] tempArray = new int[size];
        this.unclusteredInstances = new IntArrayList(size);
        for (i = 0; i < size; ++i) {
            tempArray[i] = i;
            this.unclusteredInstances.add(i);
        }
        for (i = size - 1; i > 0; --i) {
            int r = this.random.nextInt(i + 1);
            int t = tempArray[i];
            tempArray[r] = tempArray[i];
            tempArray[i] = t;
        }
        this.unclusteredInstances = new IntArrayList();
        this.unclusteredInstances.add(tempArray, 0, size);
    }

    @Override
    public String toString() {
        return "class=" + this.getClass().getName() + "\nstoppingThreshold=" + this.stoppingThreshold + "\ndoPostConvergenceMerges=" + this.doPostConvergenceMerges + "\nneighborhoodEvaluator=[" + this.evaluator + "]";
    }
}

