/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Labels;
import cc.mallet.types.LabelsSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Target2LabelSequence
extends Pipe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Target2LabelSequence() {
        super(null, new LabelAlphabet());
    }

    @Override
    public Instance pipe(Instance carrier) {
        Object target = carrier.getTarget();
        if (target != null && !(target instanceof LabelSequence)) {
            if (target instanceof FeatureSequence) {
                LabelAlphabet dict = (LabelAlphabet)this.getTargetAlphabet();
                FeatureSequence fs = (FeatureSequence)target;
                Label[] lbls = new Label[fs.size()];
                for (int i = 0; i < fs.size(); ++i) {
                    lbls[i] = dict.lookupLabel(fs.getObjectAtPosition(i));
                }
                carrier.setTarget(new LabelSequence(lbls));
            } else if (target instanceof TokenSequence) {
                Alphabet v = this.getTargetAlphabet();
                TokenSequence ts = (TokenSequence)target;
                int[] indices = new int[ts.size()];
                for (int i = 0; i < ts.size(); ++i) {
                    indices[i] = v.lookupIndex(((Token)ts.get(i)).getText());
                }
                LabelSequence ls = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), indices);
                carrier.setTarget(ls);
            } else if (target instanceof LabelsSequence) {
                LabelAlphabet dict = (LabelAlphabet)this.getTargetAlphabet();
                LabelsSequence lblseq = (LabelsSequence)target;
                Label[] labelArray = new Label[lblseq.size()];
                for (int i = 0; i < lblseq.size(); ++i) {
                    Labels lbls = lblseq.getLabels(i);
                    if (lbls.size() != 1) {
                        throw new IllegalArgumentException("Cannot convert Labels at position " + i + " : " + lbls);
                    }
                    labelArray[i] = dict.lookupLabel(lbls.get(0).getEntry());
                }
                LabelSequence ls = new LabelSequence(labelArray);
                carrier.setTarget(ls);
            } else {
                throw new IllegalArgumentException("Unrecognized target type: " + target);
            }
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }
}

