% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_herlang.R
\name{herlang.param}
\alias{herlang.param}
\title{Determine hyper-Erlang parameters}
\usage{
herlang.param(data, shape, ...)
}
\arguments{
\item{data}{A dataframe}

\item{shape}{A vector of shape parameters}

\item{...}{Others}
}
\value{
An instance of HErlang
}
\description{
Determine the hyper-Erlang parameters with k-means.
}
\examples{
## Create data
wsample <- rweibull(10, shape=2)
(dat <- data.frame.phase.time(x=wsample))

## Generate PH that is fitted to dat
(model <- herlang.param(data=dat, shape=c(1,2,3)))

}
