% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapfit.R
\name{mapfit.group}
\alias{mapfit.group}
\title{MAP fitting with grouped data}
\usage{
mapfit.group(map, counts, breaks, intervals, instants, ...)
}
\arguments{
\item{map}{An object of R6 class. The estimation algorithm is selected depending on this class.}

\item{counts}{A vector of the number of points in intervals.}

\item{breaks}{A vector for a sequence of points of boundaries of intervals.
This is equivalent to \code{c(0,cumsum(intervals))}.
If this is missing, it is assigned to \code{0:length(counts)}.}

\item{intervals}{A vector of time lengths for intervals.
This is equivalent to \code{diff(breaks)}).
If this is missing, it is assigned to \code{rep(1,length(counts))}.}

\item{instants}{A vector of integers to indicate whether sample is drawn at
the last of interval. If instant is 1, a sample is drawn at the last of interval.
If instant is 0, no sample is drawn at the last of interval.
By using instant, point data can be expressed by grouped data.
If instant is missing, it is given by \code{rep(0L,length(counts))}, i.e.,
there are no samples at the last of interval.}

\item{...}{Further options for EM steps.}
}
\value{
Returns a list with components, which is an object of S3 class \code{mapfit.result};
\item{model}{an object for estimated MAP class.}
\item{llf}{a value of the maximum log-likelihood.}
\item{df}{a value of degrees of freedom of the model.}
\item{aic}{a value of Akaike information criterion.}
\item{iter}{the number of iterations.}
\item{convergence}{a logical value for the convergence of estimation algorithm.}
\item{ctime}{computation time (user time).}
\item{data}{an object for data class}
\item{aerror}{a value of absolute error for llf at the last step of algorithm.}
\item{rerror}{a value of relative error for llf at the last step of algorithm.}
\item{options}{a list of options used in the fitting.}
\item{call}{the matched call.}
}
\description{
Estimates MAP parameters from grouped data.
}
\examples{
## load trace data
data(BCpAug89)
BCpAug89s <- head(BCpAug89, 50)

## make grouped data
BCpAug89.group <- hist(cumsum(BCpAug89s),
                         breaks=seq(0, 0.15, 0.005),
                         plot=FALSE)
                         
## MAP fitting for general MAP
(result1 <- mapfit.group(map=map(2),
                        counts=BCpAug89.group$counts,
                        breaks=BCpAug89.group$breaks))
## MAP fitting for MMPP
(result2 <- mapfit.group(map=mmpp(2),
                         counts=BCpAug89.group$counts,
                         breaks=BCpAug89.group$breaks))
                         
## MAP fitting with approximate MMPP
(result3 <- mapfit.group(map=gmmpp(2),
                         counts=BCpAug89.group$counts,
                         breaks=BCpAug89.group$breaks))

## marginal moments for estimated MAP
map.mmoment(k=3, map=result1$model)
map.mmoment(k=3, map=result2$model)
map.mmoment(k=3, map=result3$model)

## joint moments for estimated MAP
map.jmoment(lag=1, map=result1$model)
map.jmoment(lag=1, map=result2$model)
map.jmoment(lag=1, map=result3$model)

## lag-k correlation
map.acf(map=result1$model)
map.acf(map=result2$model)
map.acf(map=result3$model)

}
