% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{ph.moment}
\alias{ph.moment}
\title{Moments of PH distribution}
\usage{
ph.moment(k, ph, ...)
}
\arguments{
\item{k}{An integer for the moments to be computed}

\item{ph}{An instance of PH distribution}

\item{...}{Others}
}
\value{
A vector of moments
}
\description{
Generate moments up to k-th moments for a given PH distribution.
}
\examples{
## create a PH with specific parameters
(param1 <- ph(alpha=c(1,0,0), 
              Q=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)), 
              xi=c(2,2,0)))

## create a CF1 with specific parameters
(param2 <- cf1(alpha=c(1,0,0), rate=c(1.0,2.0,3.0)))

## create a hyper Erlang with specific parameters
(param3 <- herlang(shape=c(2,3), mixrate=c(0.3,0.7), rate=c(1.0,10.0)))

## up to 5 moments 
ph.moment(5, param1)
ph.moment(5, param2)
ph.moment(5, param3)

}
