% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{check}
\usage{
check(
  x = NULL,
  y = NULL,
  z = NULL,
  field = NULL,
  edge = 0,
  filter = 1,
  resolution = NULL
)
}
\arguments{
\item{x}{SpatRaster. Required. Must be have a defined Cartesian coordinate 
system. Data must be continuous. If more than one layer, the first layer 
will be used.}

\item{y}{SpatVector of polygons. Optional. Delineates the area within
which the raster layer shall be locally adapted and evaluated. If not provided,
the analyses will be performed within the intersect of the raster and the
sampled area. Must be have a defined Cartesian coordinate system (same as x).}

\item{z}{SpatVector of points Required. Must have at least one column
with numerical data and these data must be of the same entity and unit as x
(specify this column by argument: field). Must be have a defined Cartesian 
coordinate system (same as x).}

\item{field}{Character value. Required. Name of the column in
y with the data that shall be used to locally adapt and evaluate the raster.}

\item{edge}{Numeric value. Optional. Specifies the width (unit of the 
coordinate reference system) of a buffer zone inside the edge of the polygon 
that is excluded from the analyses. Allowed values are within the closed range 
of 0-10000.}

\item{filter}{Positive integer. Optional. No of cells in the side of a square
window for mean filtering of x. Filtering is done before any resampling
(see argument: resolution). Allowed values are within the closed range of 1-20.}

\item{resolution}{Positive numeric value. Optional. The resolution (m) to
which the imported raster shall be resampled before the adaptation. Allowed
values are within the closed range of 0.1-10000. In addition, a resolution that
means more than 1E+8 raster cells is not allowed.}
}
\value{
A list with checked and corrected data sets together with a vector of logged feedback.
}
\description{
Checks attributes, geometries and projections of spatial data sets.
}
\details{
Intended for checking data in functions of mapsRinteractive.
}
\keyword{Internal}
