% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_shift.r
\name{estimate_shift}
\alias{estimate_shift}
\alias{estimate.mouf.nls}
\alias{getP.nls}
\alias{geMu.nls}
\title{Estimating range shifts}
\usage{
estimate_shift(T, X, Y, n.clust = 2, p.m0 = NULL, dt0 = min(5,
  diff(range(T))/20), method = c("ar", "like")[1], CI = TRUE, nboot = 100,
  model = NULL, area.direct = NULL)
}
\arguments{
\item{T}{time}

\item{X}{x coordinate}

\item{Y}{y coordinate}

\item{n.clust}{the number of ranges to estimate.  Two is relatively easy and robust, and three works fairly will (with good initial guesses).  More can be prohibitively slow.}

\item{p.m0}{initial parameter guesses - a named vector with (e.g.) elements x1, x2, y1, y2, t1, dt.  It helps if this is close - the output of \code{\link{quickfit}} can be helpful, as can plotting the curve and using \code{\link{locator}}. If left as NULL, the function will make some guesses for you - starting with \code{quickfit}.}

\item{dt0}{initial guess for duration of migration}

\item{method}{one of `ar` or `like` (case insenstive), whether or not to use the AR equivalence method (faster, needs regular data - with some tolerance for gaps) or Likelihood method, which is slower but robust for irregular data.}

\item{CI}{whether or not to estimate confidence intervals}

\item{nboot}{number of bootstraps}

\item{model}{one of "MWN", "MOU" or "MOUF" (case insensitive).  By default, the algorithm selects the best one according to AIC using the \code{\link{selectModel}} function.}

\item{area.direct}{passed as direct argument to getArea}
}
\value{
a list with the following elements
\item{T,X,Y}{Longitude coordinate with NA at prediction times} 
\item{p.hat}{Point estimates of parameters}
\item{p.CI}{Data frame of parameter estimates with (approximate) confidence intervals.}
\item{model}{One of "wn", "ou" or "ouf" - the selected model for the residuals.}
\item{hessian}{The hessian of the mean parameters.}
}
\description{
Estimation and helper functions for nls fit of migration model
}
\details{
This algorithm minimizes the square of the distance of the locations from a double-headed hockeystick curve, then estimates the times scale using the ARMA/AR models.  Confidence intervals are obtained by bootstrapping the data and reestimating. See example and vignette for implementation.
}
\examples{
# load simulated tracks
data(SimulatedTracks)

# white noise fit
MWN.fit <- with(MWN.sim, estimate_shift(T=T, X=X, Y=Y))
summary(MWN.fit)
plot(MWN.fit)

if(interactive()){
# OUF fit
MOUF.fit <- with(MOUF.sim.random, 
                estimate_shift(T=T, X=X, Y=Y, 
                               model = "ouf", 
                               method = "like"))
summary(MOUF.fit)
plot(MOUF.fit)

# Three range fit:
# it is helpful to have some initital values for these parameters 
# because the automated quickfit() method is unreliable for three ranges
# in the example, we set a seed that seems to work
# set.seed(1976)

 MOU.3range.fit <- with(MOU.3range, 
                       estimate_shift(T=T, X=X, Y=Y, 
                                      model = "ou", 
                                      method = "ar", 
                                      n.clust = 3))
 summary(MOU.3range.fit)
 plot(MOU.3range.fit)
}
}
