% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdSensitivity.R
\name{thresholdSensitivity}
\alias{thresholdSensitivity}
\title{Sensitivity testing for thresholds}
\usage{
thresholdSensitivity(
  datedOccs,
  maskLayer,
  maskClass,
  sdm,
  maskProjection = NULL,
  maskVal = NULL,
  selectedValue = NULL
)
}
\arguments{
\item{datedOccs}{a `SpatialPointsDataFrame` where one column is labeled `date` and has class `POSIXct`, e.g., as obtained from using `lubridate::parse_date_time`}

\item{maskLayer}{the layer from which you will build the mask. Usually the most recent satellite derived raster}

\item{maskClass}{either top5, aroundSelected, quants, or userSpecified. "top5" ranks the environmental values at occurrences and returns the 5 highest observed values."aroundSelected" selects two observed values above and two below a user-specified threshold value. "quants" returns quantile values as thresholds. "userSpecified" will take a list of values defined by the user.}

\item{sdm}{previously generated species distribution model}

\item{maskProjection}{(optional) a proj4string showing the projection of the maskLayer. If NULL, areas will be estimated using the raster package.}

\item{maskVal}{(optional) a user defined value for thresholding when using the "aroundSelected" maskClass, or if "userSpecified", a list of thresholds to use.}

\item{selectedValue}{(optional) a user selected value around which masks will be selected using the nearest two threshold on either side}
}
\value{
returns a list containing two items. The first is a rasterstack of the masked distributions. The second item is a table of thresholds and areas
}
\description{
Measure a number of reasonable thresholds and calculate areas based on these thresholds
}
\details{
See Examples.
}
\author{
Peter Galante <pgalante@amnh.org>
}
