% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertAirDensity.R
\name{uncertAirDensity}
\alias{uncertAirDensity}
\title{Uncertainties in air density calculations}
\usage{
uncertAirDensity(model = "CIMP2007", Temp = 20, p = 1013.25, h = 50,
  u_Temp = 2.9, u_p = 10.1, u_h = 11.3, unitsENV = c("deg.C", "hPa",
  "\%"), plot = TRUE, printRelSD = TRUE)
}
\arguments{
\item{model}{model to use for air density calculation.
Must be one of \code{'CIMP2007'} (default),
\code{'CIMP.approx'} or \code{'Jones1978'}. See See Details for references.}

\item{Temp}{ambient temperature in weighing room.}

\item{p}{barometric pressure in weighing room.}

\item{h}{relative humidity in weighing room.}

\item{u_Temp}{standard uncertainty of temperature measurement}

\item{u_p}{standard uncertainty of barometric pressure measurement}

\item{u_h}{standard uncertainty of relative humidity}

\item{unitsENV}{character vector of length three with the units of
\code{p}, \code{Temp} and \code{h}.
Default is \code{c('deg.C', 'hPa', '\%')}. See \strong{unitsENV} below for more options.}

\item{plot}{logical. If \code{TRUE} (the default), the relative
uncertainty contributions are shown in a \link[graphics]{barplot}.}

\item{printRelSD}{Logical. If \code{TRUE} (the default), a short
statement indicating relative standard uncertainty
of the air density estimation is printed.}
}
\value{
A numeric value of standard uncertainty of calculated air density in \eqn{g~cm^{-3}}.
}
\description{
Propagates the uncertainty of environmental conditions measurements
to estimated values of air densities calculated using the function
\code{\link[=airDensity]{airDensity()}} with models \code{'CIMP2007'} y \code{'CIMP.approx'}
function. Uncertainty arising from to the chosen model itself is
considered. Calculations are made according to the
Guide to the Guide to the expression of uncertainty
in measurement (GUM, JCGM, 2008) as implemented
by the package \link[metRology]{metRology} (Ellison, 2018).
}
\section{unitsENV}{

Temperature units (\code{Temp}) can be either \code{'deg.C'}
(for Celsius degrees) or \code{'K'}.
Pressure units (\code{p}) can be any of \code{'mmHg'},
\code{'Pa'}, \code{'hPa'} or \code{'kPa'}.
Relative humidity (\code{h}) can be expressed as
fraction (\code{'frac'}) or as percentage (\code{'\%'}).
A typical arrangement for the parameter \code{unitsENV}
would be \code{c('deg.C', 'hPa', '\%')}.
}

\examples{
 uncertAirDensity(model = 'CIMP2007',
                  Temp = 20, p = 1013.25, h = 50,
                  u_Temp = 0.29, u_p = 1.01, u_h = 11.3)

}
\references{
Picard, A; Davis, R S; Gläser, M; Fujii, K  (2008).
Revised formula for the density of moist air (CIPM-2007).
Metrologia, 45(2), 149–155. doi:10.1088/0026-1394/45/2/004

Harris, G. (2019). Selected Laboratory and Measurement
Practices and Procedures to Support Basic Mass Calibrations.
SOP 2 - Recommended Standard Operating Procedure for Applying Air Buoyancy
Corrections. National Institute of Standards and Technology
(NIST). doi:10.6028/NIST.IR.6969-2019

BIMP JCGM (2008) Evaluation of measurement data —
Guide to the expression of uncertainty in measurement.

Stephen L R Ellison. (2018). metRology: Support for
Metrological Applications. R package version 0.9-28-1.
https://CRAN.R-project.org/package=metRology
}
\seealso{
\code{\link[=airDensity]{airDensity()}}
}
