% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncert_masses.R
\name{uncertErrorCorr}
\alias{uncertErrorCorr}
\title{Uncertainty due to mass correction using calibration certificate}
\usage{
uncertErrorCorr(calibCert, reading, units = NULL)
}
\arguments{
\item{calibCert}{object of class \code{"calibCert"} with the calibration
data of the balance. See \code{\link[=calibCert]{calibCert()}} for details.}

\item{reading}{numeric with balance reading for the mass of the object.}

\item{units}{character with the units of \code{reading}. Must be a SI unit.
If not provided, the balance standard units are assumed.
See \code{\link[=calibCert]{calibCert()}} for details.}
}
\value{
A numeric value of uncertainty for a conventional mass correction.
}
\description{
Given a balance reading indication and the calibration information
of the balance, the function
uses the conventional mass correction uncertainties of the two
closest calibration points to the balance reading to interpolate
the uncertainty due to the conventional mass correction.
}
\examples{
  data(minimalCert)
  uncertErrorCorr(reading = 12.4835, calibCert = minimalCert)
}
\seealso{
\code{\link[=convMass]{convMass()}}, \code{\link[=uncertReading]{uncertReading()}}, \code{\link[=uncertConvMass]{uncertConvMass()}}
}
