% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hri.R
\name{hri}
\alias{hri}
\title{All stable matchings in the hospital/residents problem with incomplete lists}
\usage{
hri(
  nStudents = ncol(s.prefs),
  nColleges = ncol(c.prefs),
  nSlots = rep(1, nColleges),
  s.prefs = NULL,
  c.prefs = NULL,
  s.range = NULL,
  c.range = NULL,
  randomization = NULL,
  seed = NULL,
  check_consistency = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{nStudents}{integer indicating the number of students (in the college admissions problem) 
or men (in the stable marriage problem) in the market. Defaults to \code{ncol(s.prefs)}.}

\item{nColleges}{integer indicating the number of colleges (in the college admissions problem) 
or women (in the stable marriage problem) in the market. Defaults to \code{ncol(c.prefs)}.}

\item{nSlots}{vector of length \code{nColleges} indicating the number of places (i.e. 
quota) of each college. Defaults to \code{rep(1,nColleges)} for the marriage problem.}

\item{s.prefs}{matrix of dimension \code{nColleges} \code{x} \code{nStudents} with the \code{j}th 
column containing student \code{j}'s ranking over colleges in decreasing order of 
preference (i.e. most preferred first).}

\item{c.prefs}{matrix of dimension \code{nStudents} \code{x} \code{nColleges} with the \code{i}th 
column containing college \code{i}'s ranking over students in decreasing order of 
preference (i.e. most preferred first).}

\item{s.range}{range of two intergers \code{s.range = c(s.min, s.max)}, where \code{s.min < s.max}. 
Produces incomplete preference lists with the length of each student's list randomly sampled from 
the range \code{[s.min, s.max]}. Note: interval is only correct if either c.range or s.range is used.}

\item{c.range}{range of two intergers \code{c.range = c(c.min, c.max)}, where \code{c.min < c.max}. 
Produces incomplete preference lists with the length of each college's list randomly sampled from 
the range \code{[c.min, c.max]}. Note: interval is only correct if either c.range or s.range is used.}

\item{randomization}{determines at which level random lottery numbers for student priorities are drawn. The default is \code{randomization = "multiple"}, where a student's priority is determined by a separate lottery at each college (i.e. local tie-breaking). For the second variant, \code{randomization = "single"}, a single lottery number determines a student's priority at all colleges (i.e. global tie breaking).}

\item{seed}{integer setting the state for random number generation.}

\item{check_consistency}{Performs consicentcy checks (Checks if there are columns in the preference matrices that only contains zeros and drops them and checks the matrixes for consistencies if they are given by characters). Defaults to \code{TRUE} but changing it to \code{FALSE} might reduce the running-time for large problems.}

\item{verbose}{logical. When set to \code{TRUE}, writes information messages on the console (recommended). Defaults to \code{FALSE}, which suppresses such messages.}

\item{...}{.}
}
\value{
\code{hri} returns a list of the following elements.
\item{s.prefs.smi}{student-side preference matrix for the stable marriage problem with incomplete lists (SMI).}
\item{c.prefs.smi}{college-side preference matrix for the stable marriage problem with incomplete lists (SMI).}
\item{s.prefs.hri}{student-side preference matrix for the college admissions problem (a.k.a. hospital/residents problem) with incomplete lists (HRI).}
\item{c.prefs.hri}{college-side preference matrix for the college admissions problem (a.k.a. hospital/residents problem) with incomplete lists (HRI).}
\item{matchings}{edgelist of matched students and colleges, inculding the number of the match
(\code{matching}) and two variables that indicate the student-optimal match (\code{sOptimal}) and 
college-optimal match (\code{cOptimal})}.
}
\description{
Finds \emph{all} stable matchings in either the 
\href{https://en.wikipedia.org/wiki/Hospital_resident}{hospital/residents} problem (a.k.a. college 
admissions problem) or the related 
\href{https://en.wikipedia.org/wiki/Stable_matching}{stable marriage} problem. 
Dependent on the problem, the results comprise the student and college-optimal or 
the men and women-optimal matchings. The implementation allows for \emph{incomplete preference 
lists} (some agents find certain agents unacceptable) and \emph{unbalanced instances} (unequal 
number of agents on both sides). The function uses the Prosser (2014) constraint encoding based on 
either given or randomly generated preferences.
}
\section{Minimum required arguments}{

\code{hri} requires the following combination of arguments, subject to the matching problem.
\describe{
\item{\code{nStudents, nColleges}}{Marriage problem with random preferences.}
\item{\code{s.prefs, c.prefs}}{Marriage problem with given preferences.}
\item{\code{nStudents, nSlots}}{College admissions problem with random preferences.}
\item{\code{s.prefs, c.prefs, nSlots}}{College admissions problem with given preferences.}
}
}

\examples{
## -----------------------
## --- Marriage problem 

## 7 men, 6 women, random preferences:
 hri(nStudents=7, nColleges=6, seed=4)

## 3 men, 2 women, given preferences:
 s.prefs <- matrix(c(1,2, 1,2, 1,2), 2,3)
 c.prefs <- matrix(c(1,2,3, 1,2,3), 3,2)
 hri(s.prefs=s.prefs, c.prefs=c.prefs)

## 3 men, 2 women, given preferences:
 s.prefs <- matrix(c("x","y", "x","y", "x","y"), 2,3)
 colnames(s.prefs) <- c("A","B","C")
 c.prefs <- matrix(c("A","B","C", "A","B","C"), 3,2)
 colnames(c.prefs) <- c("x","y")
 hri(s.prefs=s.prefs, c.prefs=c.prefs)

## --------------------------------
## --- College admission problem 

## 7 students, 2 colleges with 3 slots each, random preferences:
 hri(nStudents=7, nSlots=c(3,3), seed=21)

## 7 students, 2 colleges with 3 slots each, given preferences:
 s.prefs <- matrix(c(1,2, 1,2, 1,NA, 1,2, 1,2, 1,2, 1,2), 2,7)
 c.prefs <- matrix(c(1,2,3,4,5,6,7, 1,2,3,4,5,NA,NA), 7,2)
 hri(s.prefs=s.prefs, c.prefs=c.prefs, nSlots=c(3,3))
 
## 7 students, 2 colleges with 3 slots each, given preferences:
 s.prefs <- matrix(c("x","y", "x","y", "x",NA, "x","y", 
                     "x","y", "x","y", "x","y"), 2,7)
 colnames(s.prefs) <- c("A","B","C","D","E","F","G")
 c.prefs <- matrix(c("A","B","C","D","E","F","G", 
                     "A","B","C","D","E",NA,NA), 7,2)
 colnames(c.prefs) <- c("x","y")
 hri(s.prefs=s.prefs, c.prefs=c.prefs, nSlots=c(3,3))
 
## 7 students, 3 colleges with 3 slots each, incomplete preferences:
 hri(nStudents=7, nSlots=c(3,3,3), seed=21, s.range=c(1,3))
 
 s.prefs <- matrix(c('S1', 'S2', NA,
                     'S3', 'S1', NA,
                     'S1', NA, NA,
                      NA, NA,NA,
                     'S2', 'S1', 'S5'),
                   nrow = 3, ncol = 5)
 
 # Note that we explicitly allow for the existence of entries refering to colleges
 # that do not exist. A warning is generated and the entry is ignored.
 colnames(s.prefs) <- c('A', 'B', 'C', 'D', 'E')
 c.prefs <- matrix(c('B', 'C','D', 'A',
                     'C', 'D', NA, NA, 
                     'D', 'B', 'A', 'E'),
                   nrow = 4, ncol = 3)
 colnames(c.prefs) <- c('S1', 'S2', 'S3')
 \donttest{
 hri(s.prefs=s.prefs, c.prefs=c.prefs, nSlots=c(3,3,3), check_consistency = TRUE)
 }
 
## --------------------
## --- Summary plots

\donttest{
## 200 students, 200 colleges with 1 slot each
 res <- hri(nStudents=200, nColleges=200, seed=12)
 plot(res)
 plot(res, energy=TRUE)
}
}
\references{
Gale, D. and L.S. Shapley (1962). College admissions and the stability 
of marriage. \emph{The American Mathematical Monthly}, 69(1):9--15.

Morizumi, Y., T. Hayashi and Y. Ishida (2011). A network visualization of stable matching in the stable 
marriage problem. \emph{Artificial Life Robotics}, 16:40--43.

Prosser, P. (2014). Stable Roommates and Constraint Programming. \emph{Lecture Notes in Computer Science, CPAIOR 2014 Edition}. 
Springer International Publishing, 8451: 15--28.
}
\author{
Thilo Klein
}
\keyword{algorithms}
