% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_compile_quantile.R
\name{f_compile_quantile}
\alias{f_compile_quantile}
\title{Estimation of quantiles}
\usage{
f_compile_quantile(qt_trgt, v_dep, v_expl, t_trgt)
}
\arguments{
\item{qt_trgt}{Numeric vector, dim k, of k quantiles for different qt-estimations}

\item{v_dep}{Numeric vector of the dependent variable}

\item{v_expl}{Numeric vector of the (k) explanatory variable(s)}

\item{t_trgt}{Numeric time target (optional)}
}
\value{
Numeric matrix with the predicted values based on each quantile regression, at time fixed in input
}
\description{
Predicted values based on each quantile regression (Koenker and Basset, 1978), at time=t_trgt, for each quantile in qt_trgt.
}
\examples{
# Import data
data("data_euro")

#' # Data process
PIB_euro_forward_4 = data_euro["GDP"][c(5:length(data_euro["GDP"][,1])),]
FCI_euro_lag_4 = data_euro["FCI"][c(1:(length(data_euro["GDP"][,1]) - 4)),]
CISS_euro_lag_4 = data_euro["CISS"][c(1:(length(data_euro["GDP"][,1]) - 4)),]

quantile_target <- as.vector(c(0.10,0.25,0.75,0.90))
results_quantile_reg <- f_compile_quantile(qt_trgt=quantile_target,
v_dep=PIB_euro_forward_4,
v_expl=cbind(FCI_euro_lag_4, CISS_euro_lag_4),
t_trgt = 30)

}
\references{
Koenker, Roger, and Gilbert Bassett Jr. "Regression quantiles." Econometrica: journal of the Econometric Society (1978): 33-50.
}
