% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{rmatrixbeta}
\alias{rmatrixbeta}
\title{Matrix Beta sampler}
\usage{
rmatrixbeta(n, p, a, b, Theta1 = NULL, Theta2 = NULL, def = 1,
  checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{p}{dimension, a positive integer}

\item{a, b}{parameters of the distribution, positive numbers with constraints given
in Details}

\item{Theta1}{numerator noncentrality parameter, a positive semidefinite real
matrix of order \code{p}; setting it to \code{NULL} (default) is
equivalent to setting it to the zero matrix}

\item{Theta2}{denominator noncentrality parameter, a positive semidefinite real
matrix of order \code{p}; setting it to \code{NULL} (default) is
equivalent to setting it to the zero matrix}

\item{def}{\code{1} or \code{2}, the definition used; see Details}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{Theta1}
and \code{Theta2}}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples a matrix Beta (type I) distribution.
}
\details{
A Beta random matrix \eqn{U} is defined as follows.
Take two independent Wishart random matrices
\ifelse{html}{\out{S<sub>1</sub> ~ W<sub>p</sub>(2a,I<sub>p</sub>,&Theta;<sub>1</sub>)}}{\eqn{S_1 \sim \mathcal{W}_p(2a,I_p,\Theta_1)}}
and
\ifelse{html}{\out{S<sub>2</sub> ~ W<sub>p</sub>(2b,I<sub>p</sub>,&Theta;<sub>2</sub>)}}{\eqn{S_2 \sim \mathcal{W}_p(2b,I_p,\Theta_2)}}.
\itemize{
\item \strong{definition 1}:
\ifelse{html}{\out{U = (S<sub>1</sub>+S<sub>2</sub>)<sup>-&frac12;</sup>S<sub>1</sub>(S<sub>1</sub>+S<sub>2</sub>)<sup>-&frac12;</sup>}}{\eqn{U = {(S_1+S_2)}^{-\frac12}S_1{(S_1+S_2)}^{-\frac12}}}
\item \strong{definition 2}:
\ifelse{html}{\out{U = S<sub>1</sub><sup>&frac12;</sup>(S<sub>1</sub>+S<sub>2</sub>)<sup>-1</sup>S<sub>1</sub><sup>&frac12;</sup>}}{\eqn{U=S_1^\frac12{(S_1+S_2)}^{-1}S_1^\frac12}}
}
In the central case, the two definitions yield the same distribution.
Under definition 2, the Beta distribution is related to the Beta type II
distribution by
\ifelse{html}{\out{U ~ V(I+V)<sup>-1</sup>}}{\eqn{U \sim V{(I+V)}^{-1}}}.

Parameters \code{a} and \code{b} are positive numbers that satisfy the
following constraints:
\itemize{
\item if both \code{Theta1} and \code{Theta2} are the null matrix,
\code{a+b > (p-1)/2}; if \code{a < (p-1)/2}, it must be half an integer;
if \code{b < (p-1)/2}, it must be half an integer
\item if \code{Theta1} is not the null matrix, \code{a >= (p-1)/2};
if \code{b < (p-1)/2}, it must be half an integer
\item if \code{Theta2} is not the null matrix, \code{b >= (p-1)/2};
if \code{a < (p-1)/2}, it must be half an integer}
}
\note{
The matrix variate Beta distribution is usually defined only for
\eqn{a > (p-1)/2} and \eqn{b > (p-1)/2}. In this case, a random matrix \eqn{U}
generated from this distribution satisfies \eqn{0 < U < I}.
For an half integer \eqn{a \le (p-1)/2}, it satisfies \eqn{0 \le U < I}
and \eqn{rank(U)=2a}.
For an half integer \eqn{b \le (p-1)/2}, it satisfies \eqn{0 < U \le I}
and \eqn{rank(I-U)=2b}.
}
\section{Warning}{

Definition 2 requires the calculation of the square root of
\ifelse{html}{\out{S<sub>1</sub> ~ W<sub>p</sub>(2a,I<sub>p</sub>,&Theta;<sub>1</sub>)}}{\eqn{S_1 \sim \mathcal{W}_p(2a,I_p,\Theta_1)}}
(see Details). While \ifelse{html}{\out{S<sub>1</sub>}}{\eqn{S_1}} is always
positive semidefinite in theory, it could happen that the simulation of
\ifelse{html}{\out{S<sub>1</sub>}}{\eqn{S_1}} is not positive semidefinite,
especially when \code{a} is small. In this case the calculation of the square root
will return \code{NaN}.
}

\examples{
Bsims <- rmatrixbeta(10000, 3, 1, 1)
dim(Bsims) # 3 3 10000
}
