% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{selectzerocols_byname}
\alias{selectzerocols_byname}
\title{Select zero columns}
\usage{
selectzerocols_byname(a, tol = 1e-06)
}
\arguments{
\item{a}{A matrix or a list of matrices.}

\item{tol}{The allowable deviation from 0 for any element.}
}
\value{
\code{a} with only zero columns selected.
}
\description{
Matrices with columns containing all zeroes are not invertible (singular).
To diagnose this problem, it is useful to find the zero columns
of a singular matrix.
This function selects (extracts) only the zero columns of a matrix.
}
\details{
A column is said to be a zero column if all elements are within \code{tol} of zero.
}
\examples{
m <- matrix(c(1, 0, 1,
              1, 0, 1),
            dimnames = list(c("r1", "r2"), c("c1", "c2", "c3")), 
            nrow = 2, ncol = 3, byrow = TRUE) \%>\% 
  setrowtype("rows") \%>\% setcoltype("cols")
selectzerocols_byname(m)
}
