% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghist.R
\name{gghist}
\alias{gghist}
\alias{gghist.mc}
\alias{gghist.mcnode}
\title{Histogram of a Monte Carlo Simulation (ggplot version)}
\usage{
gghist(x, ...)

\method{gghist}{mcnode}(
  x,
  griddim = NULL,
  xlab = names(x),
  ylab = "Frequency",
  main = "",
  bins = 30,
  which = NULL,
  ...
)

\method{gghist}{mc}(
  x,
  griddim = NULL,
  xlab = names(x),
  ylab = "Frequency",
  main = "",
  bins = 30,
  ...
)
}
\arguments{
\item{x}{an `mc` or an `mcnode` object}

\item{...}{Further arguments to be passed to geom_histogram()}

\item{griddim}{A vector of two integers, indicating the size of the grid of the graph. 
If `NULL`, the grid is calculated to produce a "nice" graph.}

\item{xlab}{Vector of labels for the x-axis. If `NULL`, use the name of the node.}

\item{ylab}{Vector of labels for the y-axis.}

\item{main}{Vector of main titles of the graph}

\item{bins}{Number of bins. Defaults to 30.}

\item{which}{An argument used for a multivariate `mcnode`. 
Can specify which variate plot to display. 
When variates are more than one, the output will be saved in a plot list by 
default or use the number of which variate to display.}
}
\value{
a ggplot object.
}
\description{
Shows histogram of a \samp{mcnode} or a \samp{mc} object by ggplot framework.
}
\examples{
data(total)
# When mcnode has one variate
gghist(xV)
# When mcnode has two variates, the two plots will be saved in a list 
# if affected to a variable
gplots <- gghist(xVUM) 
# show the first variate plot of xVUM mcnode
gplots[[1]] 
# directly show the first variate plot of xVUM mcnode
gghist(xVUM, which = 1) #directly show the first variate plot of xVUM mcnode
# Post process
gplots[[1]] + ggplot2::geom_histogram(color = "red",fill="blue")

}
\seealso{
[hist.mc()]
}
\author{
Yu Chen and Regis Pouillot
}
