% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_module_brackets.R
\name{process_module_brackets}
\alias{process_module_brackets}
\title{Process Module Brackets Recursively}
\usage{
process_module_brackets(
  module_abundance = sub_Sample_KO_pathway,
  module_steps_str = module_steps_str,
  bracket_count = 1,
  step_count = 1,
  module_name = "Module",
  raw_module_steps = module_steps_str,
  plus_scale_method,
  comma_scale_method,
  abundance_log = list()
)
}
\arguments{
\item{module_abundance}{Data frame containing KO abundance data for the module}

\item{module_steps_str}{String representation of module steps/structure}

\item{bracket_count}{Counter for tracking nested bracket levels}

\item{step_count}{Counter for tracking processing steps}

\item{module_name}{Name of the module being processed}

\item{raw_module_steps}{Original unprocessed module steps string}

\item{plus_scale_method}{Scaling method for plus-separated KOs ("mean", "min", or "max")}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}

\item{abundance_log}{A character vector of timestamped log messages}
}
\value{
A list with two components:
\itemize{
\item \code{data}: Data frame containing processed abundance values with:
- Rows for each bracket level and final step
- Consistent sample columns as input
\item \code{log}: A character vector of timestamped log messages.
}
}
\description{
Recursively processes nested brackets in module definitions to calculate
pathway completeness or abundance scores. Handles complex pathway structures
with multiple nesting levels.
}
