% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{as_tokens}
\alias{as_tokens}
\title{Coerce object to class \code{tokens}}
\usage{
as_tokens(x, ...)
}
\arguments{
\item{x}{Object to coerce.}

\item{...}{Additional arguments (not implemented).}
}
\value{
An object of class \code{\link{tokens}}.
}
\description{
This function coerces a character object or another object that can be coerced
to a character into an object of class \code{\link{tokens}}.
}
\examples{
toy_corpus <- "Once upon a time there was a tiny toy corpus.
It consisted of three sentences. And it lived happily ever after."

tks <- tokenize(toy_corpus)
print(tks, n = 1000)

tks[3:12]
print(as_tokens(tks[3:12]), n = 1000)
as_tokens(tail(tks))
}
