% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpath.R
\name{find_xpath}
\alias{find_xpath}
\title{Run XPath query}
\usage{
find_xpath(x, pattern, fun = NULL, final_fun = NULL, namespaces = NULL, ...)
}
\arguments{
\item{x}{A corpus: an \code{\link{fnames}} object, a character vector of an XML source,
or a document parsed with \code{\link[xml2:read_xml]{xml2::read_xml()}}.}

\item{pattern}{An XPath query.}

\item{fun}{Function to be applied to the individual nodes prior
to returning the result.}

\item{final_fun}{Function to be applied to the complete list
of matches prior to returning the result.}

\item{namespaces}{A namespace as generated by \code{\link[xml2:xml_ns]{xml2::xml_ns()}}.}

\item{...}{Additional arguments.}
}
\value{
A nodeset or the output of applying \code{fun} to a nodeset.
}
\description{
This function finds matches for an XPath query in a corpus.
}
\examples{
test_xml <- '
<p>
  <w pos="at">The</w>
  <w pos="nn">example</w>
  <punct>.</punct>
</p>'

find_xpath(test_xml, "//w")
find_xpath(test_xml, "//@pos")
find_xpath(test_xml, "//w[@pos='nn']")

find_xpath(test_xml, "//w", fun = xml2::xml_text)
find_xpath(test_xml, "//w", fun = xml2::xml_attr, attr = "pos")
}
