% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fnames.R, R/freqlist.R,
%   R/tokenize.R, R/types.R
\name{keep_bool}
\alias{keep_bool}
\alias{drop_bool}
\alias{drop_bool.fnames}
\alias{keep_bool.fnames}
\alias{drop_bool.freqlist}
\alias{keep_bool.freqlist}
\alias{drop_bool.tokens}
\alias{keep_bool.tokens}
\alias{drop_bool.types}
\alias{keep_bool.types}
\title{Subset an object based on logical criteria}
\usage{
keep_bool(x, bool, invert = FALSE, ...)

drop_bool(x, bool, ...)

\method{drop_bool}{fnames}(x, bool, ...)

\method{keep_bool}{fnames}(x, bool, invert = FALSE, ...)

\method{drop_bool}{freqlist}(x, bool, ...)

\method{keep_bool}{freqlist}(x, bool, invert = FALSE, ...)

\method{drop_bool}{tokens}(x, bool, ...)

\method{keep_bool}{tokens}(x, bool, invert = FALSE, ...)

\method{drop_bool}{types}(x, bool, ...)

\method{keep_bool}{types}(x, bool, invert = FALSE, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{bool}{A logical vector of the same length as \code{x}. If \code{bool} is not
of the correct length, it is \emph{recycled}. Assuming \code{invert} is
\code{FALSE}, those items are selected for which \code{bool} is \code{TRUE}.}

\item{invert}{Logical. Whether the matches should be selected rather than the
non-matches.}

\item{...}{Additional arguments.}
}
\value{
Object of the same class as \code{x} with the selected elements only.
}
\description{
These methods can be used to subset objects based on a logical vector.
}
\details{
The methods \code{\link[=keep_pos]{keep_pos()}} and \code{\link[=drop_pos]{drop_pos()}} are part of a family of methods of
the mclm package used to subset different objects. The methods
starting with \code{keep_} extract the items in \code{x} based on the criterion specified
by the second argument. In contrast, the methods starting with \code{drop_} \emph{exclude}
the items that match the criterion in the same argument.

Calling a \code{drop_} method is equivalent to calling its \code{keep_} counterpart when
the \code{invert} argument is \code{TRUE}.
}
\examples{
# For a 'freqlist' object---------------------
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

keep_bool(flist, type_freqs(flist) < 2)
drop_bool(flist, type_freqs(flist) >= 2)
keep_bool(flist, ranks(flist) <= 3)

keep_bool(flist, c(FALSE, TRUE, TRUE, FALSE)) 

(flist2 <- keep_bool(flist, type_freqs(flist) < 2))
keep_bool(flist2, orig_ranks(flist2) > 2)

# For a 'types' object ----------------------
(tps <- as_types(letters[1:10]))

keep_bool(tps, c(TRUE, FALSE))
drop_bool(tps, c(TRUE, FALSE))

# For a 'tokens' object ----------------------
(tks <- as_tokens(letters[1:10]))

keep_bool(tks, c(TRUE, FALSE))
drop_bool(tks, c(TRUE, FALSE))
}
\seealso{
Other subsetters: 
\code{\link{brackets}},
\code{\link{keep_pos}()},
\code{\link{keep_re}()},
\code{\link{keep_types}()}
}
\concept{subsetters}
