% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc.R
\name{merge_conc}
\alias{merge_conc}
\title{Merge concordances}
\usage{
merge_conc(..., show_warnings = TRUE)
}
\arguments{
\item{...}{Two or more objects of class \code{\link{conc}}.}

\item{show_warnings}{Logical. If \code{FALSE}, warnings are suppressed.}
}
\value{
An object of class \code{\link{conc}}.
}
\description{
This function merges multiple objects of class \code{\link{conc}} into one \code{\link{conc}} object.
}
\examples{
(cd_1 <- conc('A first very small corpus.', '\\\\w+', as_text = TRUE))
as.data.frame(cd_1)

(cd_2 <- conc('A second very small corpus.', '\\\\w+', as_text = TRUE))
(cd_3 <- conc('A third very small corpus.', '\\\\w+', as_text = TRUE))
(cd <- merge_conc(cd_1, cd_2, cd_3))
as.data.frame(cd)
}
