% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcparallelDo.R
\name{mcparallelDo}
\alias{\%mcpDo\%}
\alias{mcparallelDo}
\title{mcparallelDo}
\usage{
mcparallelDo(code, targetValue, verbose = TRUE,
  targetEnvironment = .GlobalEnv)

targetValue \%mcpDo\% code
}
\arguments{
\item{code}{The code to evaluate within a fork wrapped in {}}

\item{targetValue}{A character element indicating the variable that the result of that job should be assigned to targetEnvironment}

\item{verbose}{A boolean element; if TRUE the completion of the fork expr will be accompanied by a message}

\item{targetEnvironment}{The environment in which you want targetValue to be created}
}
\value{
If \code{verbose} is set to TRUE, then the \code{character} variable name of the job. This can be manually collected via mccollect or, if on Windows, an empty string.  If \code{verbose} is set to FALSE, then NULL.
}
\description{
This function creates a fork, 
sets the variable named \code{targetValue} in the \code{targetEnvironment} to NULL,
evaluates a segment of code evaluated in the fork, 
and the result of the fork returned in a variable named \code{targetValue} in the \code{targetEnvironment} after the next top-level command completes.
If there is an error in the code, the returned variable will be a \code{try-error}.
These effects are accomplished via the automatic creation and destruction of a taskCallback and other functions inside the mcparallelDoManager.
If job results have to be collected before you return to the top level, use \link{mcparallelDoCheck}.

\%mdpDo\% Is an alternate form of calling the function, as if it were an assignment operator.  See examples.
}
\examples{
## Create data
data(ToothGrowth)
## Trigger mcparallelDo to perform analysis on a fork
mcparallelDo({glm(len ~ supp * dose, data=ToothGrowth)},"interactionPredictorModel")
## Do other things
binaryPredictorModel <- glm(len ~ supp, data=ToothGrowth)
gaussianPredictorModel <- glm(len ~ dose, data=ToothGrowth)
## The result from mcparallelDo returns in your targetEnvironment, 
## e.g. .GlobalEnv, when it is complete with a message (by default)
summary(interactionPredictorModel)

# Example of not returning a value until we return to the top level
for (i in 1:10) {
  if (i == 1) {
    mcparallelDo({2+2}, targetValue = "output")
  }
  if (exists("output")) print(i)
}

# Example of getting a value without returning to the top level
for (i in 1:10) {
  if (i == 1) {
    mcparallelDo({2+2}, targetValue = "output")
  }
  mcparallelDoCheck()
  if (exists("output")) print(i)
}

# Example of dispatching as assignment
targetValueWithoutQuotes \%mcpDo\% sample(LETTERS, 10)

}

