% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_methods.R
\name{getOutlier}
\alias{getOutlier}
\alias{getOutlier,BAsummary-method}
\title{Detect Outliers From \code{BAsummary} Object}
\usage{
getOutlier(object, ...)

\S4method{getOutlier}{BAsummary}(
  object,
  method = c("ESD", "4E"),
  difference = c("abs", "rel"),
  alpha = 0.05,
  h = 5
)
}
\arguments{
\item{object}{(\code{BAsummary})\cr input from \link{blandAltman} function to generate the Bland-Altman
analysis result that contains the absolute and relative differences.}

\item{...}{not used.}

\item{method}{(\code{string})\cr string specifying which method to use. Default is \code{ESD}.}

\item{difference}{(\code{string})\cr string specifying which difference type to use for \code{ESD} method.
Default is \code{abs} that means absolute difference, and \code{rel} is relative difference.}

\item{alpha}{(\code{numeric})\cr type-I-risk. Only used when the method is defined as \code{ESD}.}

\item{h}{(\code{integer})\cr the positive integer indicating the number of suspected outliers.
Only used when the method is defined as \code{ESD}.}
}
\value{
A list contains the statistics results (\code{stat}), outliers' ord id (\code{ord}),
sample id (\code{sid}), matrix with outliers (\code{outmat}) and matrix without outliers (\code{rmmat}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Detect the potential outliers from the absolute and relative differences in
\code{BAsummary} object with 4E and ESD method.
}
\note{
Bland-Altman analysis is used as the input data regardless of the 4E and ESD
method because it's necessary to determine the absolute and relative differences beforehand.
For the 4E method, both of the absolute and relative differences are required to
be define, and the bias exceeds the 4 fold of the absolute and relative differences.
However for the ESD method, only one of them is necessary (the latter is more recommended),
and the bias needs to meet the ESD test.
}
\examples{
data("platelet")
# Using `blandAltman` function with default arguments
ba <- blandAltman(x = platelet$Comparative, y = platelet$Candidate)
getOutlier(ba, method = "ESD", difference = "rel")

# Using sample id as input
ba2 <- blandAltman(x = platelet$Comparative, y = platelet$Candidate, sid = platelet$Sample)
getOutlier(ba2, method = "ESD", difference = "rel")

# Using `blandAltman` function when the `tyep2` is 2 with `X vs. (Y-X)/X` difference
ba3 <- blandAltman(x = platelet$Comparative, y = platelet$Candidate, type2 = 4)
getOutlier(ba3, method = "ESD", difference = "rel")

# Using "4E" as the method input
ba4 <- blandAltman(x = platelet$Comparative, y = platelet$Candidate)
getOutlier(ba4, method = "4E")
}
