% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizumat2.R
\name{vizu.mat}
\alias{vizu.mat}
\title{Visualize matrix data in a form of a heatmap, with continuous values legend}
\usage{
vizu.mat(matrix.object, title = "", base_size = 12, adjust.limits = TRUE,
  adjust.colors = TRUE, fill.scale.limits = NULL, colors.palette = NULL,
  geom_tile.colour = "grey90", clear.labels = TRUE, clear.x.label = FALSE,
  clear.y.label = FALSE, uniform.labes = FALSE, rotate.x.labels = FALSE,
  x.lab = "", y.lab = "", axis.text.x.size = base_size - 2,
  axis.text.y.size = base_size - 2, axis.title.x.size = base_size - 2,
  axis.title.y.size = base_size - 2, legend.text.size = base_size - 2,
  legend.title.size = base_size - 2, legend.title = "value",
  text.font.family = "Helvetica", remove.legend = FALSE,
  axis.text.x.breaks.idx = NULL, axis.text.y.breaks.idx = NULL)
}
\arguments{
\item{matrix.object}{matrix}

\item{title}{plot title}

\item{base_size}{base font size}

\item{adjust.limits}{logical whether or not adjust legend scale limits automatically:
\itemize{
\item legend scale starts / ends with 0 for matrix with non-negative / non-positive values only,
\item legend scale is symmetric for matrix with both negative and positive values
}}

\item{adjust.colors}{logical whether or not adjust legend color automatically:
\itemize{
\item legend color palette white-red for a data matrix with non-negative values only,
\item legend color palette blue-white for a data matrix with non-positive values only,
\item legend color palette blue-white-red for a data matrix with both positive and negative values
}}

\item{fill.scale.limits}{2-element vector defining legend scale limits}

\item{colors.palette}{legend color color palette}

\item{geom_tile.colour}{tiles color value}

\item{clear.labels}{logical whether or not clear both x- and y-axis labels}

\item{clear.x.label}{logical whether or not clear x-axis labels}

\item{clear.y.label}{logical whether or not clear y-axis labels}

\item{uniform.labes}{logical whether or not define generic short column and rows labeling:
\itemize{
\item 'c1','c2',...,'cp' for columns,
\item 'r1','r2',...,'rp' for rows;
might be especially useful if the matrix some long colnames and rownames already assigned
}}

\item{rotate.x.labels}{logical whether or not rotate x-axis labels by 90 degrees}

\item{x.lab}{x-axis label}

\item{y.lab}{y-axis label}

\item{axis.text.x.size}{font size of x-axis text}

\item{axis.text.y.size}{font size of y-axis text}

\item{axis.title.x.size}{font size of x-axis label}

\item{axis.title.y.size}{font size of y-axis label}

\item{legend.text.size}{font size of legend text}

\item{legend.title.size}{font size of legend title}

\item{legend.title}{legend title}

\item{text.font.family}{font family}

\item{remove.legend}{logical whether or not remove legend}

\item{axis.text.x.breaks.idx}{indices of x-axis elements whose thicks are kept
and whose numerical labels are kept}

\item{axis.text.y.breaks.idx}{indices of y-axis elements whose thicks are kept
and whose numerical labels are kept}
}
\value{
\code{ggplot2} object
}
\description{
Matrix data visualization in a form of a heatmap, with
the use of \code{ggplot2} library. Minimum user input (a matrix object) is needed to produce decent visualization output.
Automatic plot adjustments are implemented and used as defaults, including
selecting legend color palette and legend scale limits.  Further
plot adjustments are available, including
adding a title, font size change, axis label clearing and others.
}
\examples{
mat <- matrix(rnorm(30*30), nrow = 30, ncol = 30)
vizu.mat(mat)
vizu.mat(mat, fill.scale.limits = c(-3,3))
vizu.mat(mat, fill.scale.limits = c(-10,10))
vizu.mat(mat, fill.scale.limits = c(-10,10), 
         uniform.labes = TRUE, clear.labels = FALSE)
colnames(mat) <- paste0("col", 1:30, sample(LETTERS, 30, replace = TRUE))
rownames(mat) <- paste0("row", 1:30, sample(LETTERS, 30, replace = TRUE))
vizu.mat(mat, fill.scale.limits = c(-10,10), 
         clear.labels = FALSE, 
         rotate.x.labels = TRUE)
mat.positive <- abs(mat)
vizu.mat(mat.positive, 
         title = "positive values only -> legend limits and colors automatically adjusted",
         clear.labels = FALSE, 
         rotate.x.labels = TRUE)

}
