% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Cherry}
\alias{Cherry}
\title{Cherry Blossom runs}
\format{
An object of class \link[tibble:tbl_df-class]{tibble::tbl_df} with 41,248 rows and 8 columns.
Each row refers to an individual runner in one race of the
Cherry Blossom Ten Miler. The data cover the years 1999 to 2008.
All of the runners listed ran
at least two of the races in that period, some ran many more than that.
\describe{
\item{name.yob}{a unique identifier for each runner composed of the runner's full name and
year of birth.}
\item{age}{integer giving the runner's age in the race whose result is being reported.}
\item{gun}{the number of minutes elapsed from the starter's gun to the person crossing the finish line}
\item{net}{the number of minutes elapsed from the runner's crossing the start line to crossing the finish line.}
\item{sex}{the runner's sex}
\item{year}{the year of that race}
\item{previous}{integer specifying how many times previous to this race the runner had participated in the years 1999 to 2008.}
\item{nruns}{integer giving the total number of times that runner participated in the years from 1999 to 2008. The smallest is 2, the largest is 10.}
\item{nruns}{integer giving the total number of times that runner participated in the years from 1999 to 2008. The smallest is 2, the largest is 10.}
}
}
\source{
\url{https://www.cherryblossom.org/post-race/race-results/}.
}
\usage{
Cherry
}
\description{
Cherry Blossom runs
}
\details{
The Cherry Blossom 10 Mile Run is a road race held in Washington,
D.C. in April each year.  (The name comes from the famous cherry trees
that are in bloom in April in Washington.)  The results of this race
are published at \url{https://www.cherryblossom.org/post-race/race-results/}.
}
\examples{
if (require(dplyr)) {
  Cherry |>
    group_by(name.yob) |>
    count() |>
    group_by(n) |>
    count(name = "appearances")
}
}
\seealso{
\emph{Data Science in R}, Nolan and Temple Lang (ISBN 978-1482234817), Ch. 2
}
\keyword{datasets}
