% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_format.R
\name{mean_format}
\alias{mean_format}
\title{Format mean_table Output for Publication and Dissemination}
\usage{
mean_format(.data, recipe, name = NA, digits = NA)
}
\arguments{
\item{.data}{A data frame of class "mean_table" or "mean_table_grouped".}

\item{recipe}{A recipe used to create a new column from existing mean_table
columns. The recipe must be in the form of a quoted string. It may contain
any combination of column names, spaces, and characters. For example:
"mean (sd)" or "mean (lcl - ucl)".}

\item{name}{An optional name to assign to the column created by the recipe.
The default name is "formatted_stats"}

\item{digits}{The number of decimal places to display.}
}
\value{
A tibble
}
\description{
The mean_format function is intended to make it quick and easy to
  format the output of the mean_table function for tables that may be used
  for publication. For example, a mean and 95% confidence interval
  could be formatted as "24.00 (21.00 - 27.00)."
}
\examples{
\dontrun{
library(dplyr)
library(meantables)

data(mtcars)

# Overall mean table with defaults

mtcars \%>\%
  mean_table(mpg) \%>\%
  mean_format("mean (sd)") \%>\%
  select(response_var, formatted_stats)

# A tibble: 1 × 2
  response_var formatted_stats
  <chr>        <chr>
1 mpg          20.09 (6.03)

# Grouped means table with defaults

mtcars \%>\%
  group_by(cyl) \%>\%
  mean_table(mpg) \%>\%
  mean_format("mean (sd)") \%>\%
  select(response_var:group_cat, formatted_stats)

  # A tibble: 3 × 4
  response_var group_var group_cat formatted_stats
  <chr>        <chr>         <dbl> <chr>
1 mpg          cyl               4 26.66 (4.51)
2 mpg          cyl               6 19.74 (1.45)
3 mpg          cyl               8 15.1 (2.56)
}
}
