% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mecor.R
\name{mecor}
\alias{mecor}
\title{mecor: a Measurement Error Correction Package}
\usage{
mecor(formula, data, method = "standard", B = 0)
}
\arguments{
\item{formula}{an object of class \link[stats]{formula} (or one that is
coerced to that class): a symbolic description of the regression model
containing a \link[mecor]{MeasError}, \link[mecor]{MeasErrorExt} or
\link[mecor]{MeasErrorRandom} object in one of the covariates or the outcome.}

\item{data}{a data.frame, list or environment (or object coercible by
as.data.frame to a data frame) containing the variables in the model
specified in \code{formula}.}

\item{method}{a character string indicating the method used to correct for
the measurement error, either "standard" (regression calibration for
covariate measurement error and method of moments for outcome measurement
error), "efficient" (efficient regression calibration for covariate
measurement error and efficient method of moments for outcome measurement
error), "valregcal" (validation regression calibration) or "mle" (maximum
likelihood estimation). Defaults to "standard".}

\item{B}{number of bootstrap samples, defaults to 0.}
}
\value{
\code{mecor} returns an object of \link[base]{class} "mecor".

An object of class \code{mecor} is a list containing the following components:

\item{corfit}{a list containing the corrected fit, including the coefficients
of the corrected fit (\code{coef}) and the variance--covariance matrix of the
coefficients of the corrected fit obtained by the delta method (\code{vcov}),
and more depending on the method used.}
\item{uncorfit}{an \link[stats]{lm.fit} object of the uncorrected fit.}
}
\description{
mecor provides correction methods for measurement error in a continuous
covariate or outcome in linear regression models with a continuous outcome
}
\examples{
## measurement error in a covariate/outcome:
# internal covariate-validation study
data(vat)
out <-
mecor(ir_ln ~ MeasError(wc, reference = vat) + sex + age + tbf,
      data = vat,
      method = "standard",
      B = 999)
# replicates study
data(bloodpressure)
mecor(creatinine ~ MeasError(sbp30, replicate = cbind(sbp60, sbp120)) + age,
      data = bloodpressure,
      method = "mle")
# outcome-calibration study
data(sodium)
mecor(MeasError(recall, replicate = cbind(urinary1, urinary2)) ~ diet,
      data = sodium,
      method = "efficient")
# external outcome-validation study
data(haemoglobin_ext)
calmod_fit <- lm(capillary ~ venous, data = haemoglobin_ext)
data(haemoglobin) # suppose reference venous is not available
mecor(MeasErrorExt(capillary, model = calmod_fit) ~ supplement,
      data = haemoglobin)
# sensitivity analyses
data(vat) # suppose reference vat is not available
# guesstimate the coefficients of the calibration model:
mecor(ir_ln ~ MeasErrorExt(wc, model = list(coef = c(0.2, 0.5, -1.3, 0, 0.6))) + sex + age + tbf,
      data = vat)
# assume random measurement error in wc of magnitude 0.25:
mecor(ir_ln ~ MeasErrorRandom(wc, variance = 0.25) + sex + age + tbf,
      data = vat)
data(bloodpressure) # suppose replicates sbp60 and sbp60 are not available
mecor(creatinine ~ MeasErrorRandom(sbp30, variance = 25) + age,
      data = bloodpressure)

## differential measurement error in the outcome:
# internal outcome-validation study
mecor(MeasError(capillary, reference = venous, differential = supplement) ~ supplement,
      data = haemoglobin,
      method = "standard")
}
\references{
L. Nab, R.H.H. Groenwold, P.M.J. Welsing, and  M. van Smeden.
Measurement error in continuous endpoints in randomised trials: problems and
solutions

L. Nab, M. van Smeden, R.H. Keogh, and R.H.H. Groenwold.
mecor: an R package for measurement error correction in linear models with
continuous outcomes
}
\author{
Linda Nab, \email{l.nab@lumc.nl}
}
