% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_meta_data.R
\name{extract_meta_data}
\alias{extract_meta_data}
\title{Extract meta data}
\usage{
extract_meta_data(html_doc)
}
\arguments{
\item{html_doc}{Character string including the html document.}
}
\value{
List with three sublists for native, open graph and twitter.
}
\description{
\code{extract_meta_data} extracts native, open graph and twitter meta data
from html documents. The meta data include url, title, description and image.
The html document is parsed within the function
}
\examples{
\dontrun{
 library(httr)
 url <- "https://bits.blogs.nytimes.com/2013/04/07/the-potential-and-the-risks-of-data-science"
 response <- GET(url)
 html_document <- content(response, type = "text", encoding = "UTF-8")
 meta_data <- extract_meta_data(html_doc = html_document)
}

}
