% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messy_dates.R
\name{messy_datetime_formats}
\alias{messy_datetime_formats}
\alias{messy_date_formats}
\title{Make date(time) formats inconsistent}
\usage{
messy_datetime_formats(
  data,
  cols = NULL,
  formats = c("\%Y/\%m/\%d \%H:\%M:\%S", "\%d/\%m/\%Y \%H:\%M:\%S")
)

messy_date_formats(
  data,
  cols = NULL,
  formats = c("\%Y/\%m/\%d", "\%d/\%m/\%Y")
)
}
\arguments{
\item{data}{input dataframe}

\item{cols}{set of columns to apply transformation to. If \code{NULL} will apply
to all POSIXt columns (for \code{\link[=messy_datetime_formats]{messy_datetime_formats()}}) or Date columns (for
\code{\link[=messy_date_formats]{messy_date_formats()}}).}

\item{formats}{A vector of any number of valid \code{\link[=strptime]{strptime()}} formats. Multiple
formats will be sampled at random.}
}
\value{
a dataframe the same size as the input data.
}
\description{
Takes any date(times) column and transforms it into a character column,
sampling from any number of random of valid character representations.
}
\examples{
data <- data.frame(dates = rep(Sys.Date(), 10))
messy_date_formats(data)
}
\seealso{
Other Messy date(time) functions: 
\code{\link{messy_datetime_tzones}()},
\code{\link{split_datetimes}()}
}
\author{
Jack Davison
}
\concept{Messy date(time) functions}
