% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-placement.R
\name{label_placers}
\alias{label_placers}
\alias{label_placer_fraction}
\alias{label_placement_fraction}
\alias{label_placer_n}
\alias{label_placement_n}
\alias{label_placer_random}
\alias{label_placement_random}
\alias{label_placer_all}
\alias{label_placement_all}
\alias{label_placer_flattest}
\alias{label_placement_flattest}
\alias{label_placer_minmax}
\alias{label_placement_minmax}
\title{Functions to place contour labels}
\usage{
label_placer_fraction(
  frac = 0.5,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placement_fraction(
  frac = 0.5,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placer_n(n = 2, rot_adjuster = isoband::angle_halfcircle_bottom())

label_placement_n(n = 2, rot_adjuster = isoband::angle_halfcircle_bottom())

label_placer_random(
  seed = 42,
  n = 1,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placement_random(
  seed = 42,
  n = 1,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placer_all(rot_adjuster = isoband::angle_halfcircle_bottom())

label_placement_all(rot_adjuster = isoband::angle_halfcircle_bottom())

label_placer_flattest(
  ref_angle = 0,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placement_flattest(
  ref_angle = 0,
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placer_minmax(
  direction = c("vertical", "horizontal"),
  rot_adjuster = isoband::angle_halfcircle_bottom()
)

label_placement_minmax(
  direction = c("vertical", "horizontal"),
  rot_adjuster = isoband::angle_halfcircle_bottom()
)
}
\arguments{
\item{frac}{A numeric vector with values between 0 and 1 representing
where in the contour to put labels (i.e. \code{frac = 0.5} puts labels
at the midpoint).}

\item{rot_adjuster}{A function that standardizes the rotation angles of the labels.
See e.g. \link[isoband:angle_halfcircle_bottom]{isoband::angle_halfcircle_bottom}.}

\item{n}{Number of labels to put.}

\item{seed}{Seed to use for randomly choosing where to put labels.}

\item{ref_angle}{Angle (in degrees counter-clockwise from East) to try
to approximate labels.}

\item{direction}{Direction in which to compute the maximum and minimum.}
}
\description{
These functions compute the position of contour labels.
}
\keyword{internal}
