% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{metaRange-package}
\alias{metaRange}
\alias{metaRange-package}
\title{metaRange: Framework to Build Mechanistic and Metabolic Constrained Species Distribution Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Build spatially and temporally explicit process-based species distribution models, that can include an arbitrary number of environmental factors, species and processes including metabolic constraints and species interactions. The focus of the package is simulating populations of one or multiple species in a grid-based landscape and studying the meta-population dynamics and emergent patterns that arise from the interaction of species under complex environmental conditions. It provides functions for common ecological processes such as negative exponential, kernel-based dispersal (see Nathan et al. (2012) \doi{10.1093/acprof:oso/9780199608898.003.0015}), calculation of the environmental suitability based on cardinal values ( Yin et al. (1995) \doi{10.1016/0168-1923(95)02236-Q}, simplified by Yan and Hunt (1999) \doi{10.1006/anbo.1999.0955} see eq: 4), reproduction in form of an Ricker model (see Ricker (1954) \doi{10.1139/f54-039} and Cabral and Schurr (2010) \doi{10.1111/j.1466-8238.2009.00492.x}), as well as metabolic scaling based on the metabolic theory of ecology (see Brown et al. (2004) \doi{10.1890/03-9000} and Brown, Sibly and Kodric-Brown (2012) \doi{10.1002/9781119968535.ch}).
}
\references{
Fallert, S., Li, L., & Sarmento Cabral, J. (2023).
metaRange: Framework to Build Mechanistic and Metabolic Constrained Species Distribution Models.
Zenodo. \doi{10.5281/zenodo.10364778}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://metaRange.github.io/metaRange/}
  \item Report bugs at \url{https://github.com/metaRange/metaRange/issues}
}

}
\author{
\strong{Maintainer}: Stefan Fallert \email{srfallert@gmail.com} (\href{https://orcid.org/0000-0002-9939-4219}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Lea Li (Implemented the first version of the metabolic scaling) [copyright holder]
  \item Juliano Sarmento Cabral \email{j.sarmentocabral@bham.ac.uk} (\href{https://orcid.org/0000-0002-0116-220X}{ORCID}) [copyright holder, thesis advisor]
}

Other contributors:
\itemize{
  \item Tyler Morgan-Wall (\href{https://orcid.org/0000-0002-3131-3814}{ORCID}) [contributor, copyright holder]
  \item Bavarian Ministry of Science and Arts (bayklif) [funder]
  \item Deutsche Bundesstiftung Umwelt (DBU) [funder]
}

}
\keyword{internal}
