% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msurv.R
\name{msurv}
\alias{msurv}
\title{Summary survival curve from aggregated survival data of a meta-analysis}
\usage{
msurv(
  study,
  time,
  n.risk,
  surv.rate,
  confidence,
  correctionFlag = TRUE,
  correctionVal = c(0.25, 0.5)
)
}
\arguments{
\item{study}{A numeric vector with the numbering of the studies included in the meta-analysis. The numbering of a study is repeated for each survival probabilities extracted from this study.}

\item{time}{A numeric vector with the time at which the survival probabilities are collected.}

\item{n.risk}{A numeric vector with the number of at-risk patients in the study for each value of thr time.}

\item{surv.rate}{A numeric vector with the survival rates collected per study for each value of time.}

\item{confidence}{A text argument indicating the method to calculate the confidence interval of the summary survival probabilities: "Greenwood" or "MonteCarlo".}

\item{correctionFlag}{A logical variable which takes into account if user wants the continuity correaction or not (By default TRUE).}

\item{correctionVal}{A numeric vector for continuity correction, if you don't want to apply correction pass c(0,0).}
}
\value{
List of fixed and random effect pooled probabilities
}
\description{
Estimation of the summary survival curve from the survival rates and the numbers of at-risk individuals extracted from studies of a meta-analysis.
}
\examples{
attach(exampleData)
result <- msurv(study = Study,
                time = Time,
                 n.risk = NbRisk,
                 surv.rate = Survival,
                 confidence = "Greenwood",
                 correctionFlag = FALSE
                 )
result
}
\author{
Shubhram Pandey \email{shubhram1992@gmail.com}
}
