% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofer.R
\name{build_gofer}
\alias{build_gofer}
\title{Build a GOfER diagram (Graphical Overview for Evidence Reviews)}
\usage{
build_gofer(page = c("1", "2"), save = FALSE, path, format = ".png")
}
\arguments{
\item{page}{A text string to indicate the page you would like to display. This GOfER has two pages (28 studies in page 1 and 28 studies in page 2).}

\item{save}{A boolean to indicate whether to save the plot to disk.}

\item{path}{Path to write to. It has to be a character string indicating the path and file name (without the extension). For example, \verb{~/Documents/metabolic_gofer_page_1} will save \code{metabolic_gofer_page_1.png} to the \code{Documents} folder.}

\item{format}{The file extension that you want to save the plot to. Only \code{.png}, is supported.}
}
\value{
A \code{patchwork} object
}
\description{
It is recommended to set \code{save = TRUE} and indicate the \code{path} to save to, as the plot is not going to look good in the \code{Plots} panel.
}
\examples{
if (interactive()) {
 build_gofer(page = "1", save = TRUE, path = tempfile())
}
}
