% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_sl_summary.R
\name{rtf_disposition}
\alias{rtf_disposition}
\title{Disposition table}
\usage{
rtf_disposition(
  outdata,
  source,
  col_rel_width = NULL,
  text_font_size = 9,
  orientation = "portrait",
  footnotes = NULL,
  title = NULL,
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_sl_summary]{prepare_sl_summary()}}.}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{footnotes}{A character vector of table footnotes.}

\item{title}{Term "analysis", "observation" and "population") for collecting title from metadata or a character vector of table titles.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
A list of analysis raw datasets.
}
\description{
Disposition table
}
\examples{
meta <- meta_sl_example()

meta |>
  prepare_disposition(population = "apat", parameter = "disposition;medical-disposition") |>
  format_disposition() |>
  rtf_disposition(
    source = "Source: [CDISCpilot: adam-adsl]",
    path_outdata = tempfile(fileext = ".Rdata"),
    path_outtable = tempfile(fileext = ".rtf")
  )
}
