% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_km}
\alias{calc_km}
\title{Calculate the Kendrick mass}
\usage{
calc_km(mass, repeating_unit = "CH2")
}
\arguments{
\item{mass}{A molecular mass (or m/z).}

\item{repeating_unit}{The formula of the repeating unit, given as a string.}
}
\value{
The Kendrick mass.
}
\description{
Calculate the Kendrick mass for a given mass (or m/z) and repeating unit.
The Kendrick mass is a rescaled mass, that usually sets CH2 = 14 but other
repeating units can also be used. It is usefull for the visual identification
of potential homologues. See the References section for more information.
The Kendrick mass is not to be confused with the Kendrick mass defect
(KMD, \code{\link[metamorphr]{calc_kmd}}) and
the nominal Kendrick mass (\code{\link[metamorphr]{calc_nominal_km}}).
}
\examples{
# Calculate the Kendrick masses for two measured masses with
# CH2 as the repeating unit.
# See Hughey et al. in the References section above

calc_km(c(351.3269, 365.3425))

# Construct a KMD plot from m/z values.
# RT is mapped to color and the feature-wise maximum intensity to size.
# Note that in the publication by Hughey et al., the nominal Kendrick mass
# is used on the x-axis instead of the exact Kendrick mass.
# See ?calc_nominal_km.

toy_metaboscape \%>\%
  dplyr::group_by(UID, `m/z`, RT) \%>\%
  dplyr::summarise(max_int = max(Intensity, na.rm = TRUE)) \%>\%
  dplyr::ungroup() \%>\%
  dplyr::mutate(KMD = calc_kmd(`m/z`),
                KM = calc_km(`m/z`)) \%>\%
  ggplot2::ggplot(ggplot2::aes(x = KM,
                               y = KMD,
                               size = max_int,
                               color = RT)) +
    ggplot2::geom_point()
}
\references{
\itemize{
\item \href{https://en.wikipedia.org/wiki/Kendrick_mass}{Kendrick mass on Wikipedia}
\item Edward Kendrick, \emph{Anal. Chem.} \strong{1963}, \emph{35}, 2146–2154.
\item C. A. Hughey, C. L. Hendrickson, R. P. Rodgers, A. G. Marshall, K. Qian, \emph{Anal. Chem.} \strong{2001}, \emph{73}, 4676–4681.
}
}
