% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metanet_build_pipe.R
\name{metanet_build_pipe}
\alias{metanet_build_pipe}
\title{Build and execute 'metanetwork' pipeline}
\usage{
metanet_build_pipe(
  metaweb,
  abTable = NULL,
  trophicTable = NULL,
  compute_local_nets = TRUE,
  verbose = TRUE,
  beta = 0.1
)
}
\arguments{
\item{metaweb}{metaweb of the metanetwork, object of class 'graph', 'matrix', 'data.frame' or 'dgCMatrix'.
Metaweb needs to be directed and connected. This parameter must be non-null.}

\item{abTable}{abundances of nodes in local networks, matrix of class 'matrix',
columns must have names corresponding to node labels of the metaweb,
rows are node abundances in local networks.
Default is null, in that case, uniform abundances are assigned}

\item{trophicTable}{a 'matrix' or 'data.frame' indicating hierarchy of the nodes.
Names of the columns correspond to the different resolutions.
It indicates the membership of each node of the metaweb. Default is null.}

\item{compute_local_nets}{a boolean, indicates whether local networks must be computed or not.
Default is \code{TRUE}}

\item{verbose}{a boolean indicating whether message along the pipeline should be printed}

\item{beta}{the diffusion parameter of the diffusion kernel, a positive scalar controlling the
squeezing of the network}
}
\value{
object of class 'metanetwork', with computed layout stored as node attribute
}
\description{
Method executing the whole metanetwork pipeline, including building 'metanetwork' object (\code{build_metanet},\code{append_agg_nets}, \code{compute_TL},
\code{attach_layout})
}
\examples{
library(metanetwork)
library(igraph)

g = make_lattice(dimvector = c(4,4),2,3,directed = TRUE)
meta0 = metanet_build_pipe(g)
ggmetanet(meta0)


}
