% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.meteDist.R
\name{plot.meteDist}
\alias{plot.meteDist}
\title{Plot METE distributions and associated data}
\usage{
\method{plot}{meteDist}(x, ptype = c("cdf", "rad"), th.col = "red",
  lower.tail = TRUE, add.legend = TRUE, add.line = FALSE, ...)
}
\arguments{
\item{x}{a \code{meteDist} object}

\item{ptype}{type of plot; either "cdf" or "rad"}

\item{th.col}{line color of theoretical prediction}

\item{lower.tail}{logical; choose TRUE to highlight differences between data and theory at low abundance; choose FALSE to highlight differences at high abundance.}

\item{add.legend}{logical; add a legend}

\item{add.line}{add the curve for a fitted model to the existing plot}

\item{...}{arguments to be passed to \code{plot}}
}
\description{
\code{plot.meteDist} plots both the theoretical prediction and data for a
\code{meteDist} object using either a rank or cumulative distribution plot
}
\details{
\code{plot.meteDist} automatically extracts the prediction and data (if used
in \code{meteESF}) from the \code{meteDist} object. Additional plotting
arguments can be passed to \code{...}.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
               abund=arth$count,
               power=arth$mass^(.75),
               minE=min(arth$mass^(.75)))
ipd1 <- ipd(esf1)
plot(ipd1)
plot(ipd1, ptype='rad')
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
sad, ipd, ssad, sipd, print.meteDist
}

