% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.sar.R
\name{plot.sar}
\alias{plot.sar}
\title{Plot the species abundance distribution (SAR), i.e. objects of class sar}
\usage{
\method{plot}{sar}(x, add = FALSE, ...)
}
\arguments{
\item{x}{an object of class SAR made with}

\item{add}{logical; should new \code{sar} object be added to current plot or made its own plot}

\item{...}{arguments passed to \code{plot}}
}
\description{
Plot species or endemics area relationship with flexibility to adjust plotting parameters
}
\details{
see examples
}
\examples{
data(anbo)
anbo.obs.sar <- empiricalSAR(anbo$spp, anbo$count, anbo$row, anbo$col, Amin=1, A0=16)
plot(anbo.obs.sar)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
empiricalSAR, downscaleSAR, upscaleSAR, meteSAR
}

