% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_colors.R
\name{mexico_palette}
\alias{mexico_palette}
\title{Mexico color palette generator}
\usage{
mexico_palette("name", n, "type")
}
\arguments{
\item{name}{Name of the specific palette in quotation marks. The options are: \code{morena}, \code{pri}, \code{pan}, \code{prd}, \code{cuatroT}}

\item{n}{Number of colors to select from the palette. If null, then all colors in the palette are selected}

\item{type}{Specify the type of color mapping, either "continuous" or "discrete" in quotation marks. Use "continuous" to include more colors than those in the palette. See \code{examples} below for more
@importFrom graphics rgb rect par image text}
}
\value{
A vector of colors
}
\description{
Mexico color palette generator
}
\examples{
# Display each palette
mexico_palette("morena")
mexico_palette("pri")
mexico_palette("pan")
mexico_palette("prd")
mexico_palette("cuatroT")

# Interpolating between existing colors based on the palettes using the "continuous" type
mexico_palette(50, name = "morena", type = "continuous")
mexico_palette(50, name = "pri", type = "continuous")
mexico_palette(50, name = "pan", type = "continuous")
mexico_palette(50, name = "prd", type = "continuous")
mexico_palette(50, name = "cuatroT", type = "continuous")
}
\references{
Philip Waggoner. 2019. amerika: American Politics-Inspired Color Palette Generator. R package version 0.1.0
}
