% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfp.R
\name{create_fp_terms}
\alias{create_fp_terms}
\title{Helper to create overview table of fp terms}
\usage{
create_fp_terms(fp_powers, acdx, df, select, alpha, criterion)
}
\arguments{
\item{fp_powers}{powers of the created FP terms.}

\item{acdx}{a logical vector of length nvars indicating which continuous
variables should undergo the approximate cumulative distribution (ACD)
transformation.}

\item{df}{a numeric vector of length nvars of degrees of freedom.}

\item{select}{a numeric vector of length nvars indicating significance levels
for backward elimination.}

\item{alpha}{a numeric vector of length nvars indicating significance levels
for tests between FP models of different degrees.}

\item{criterion}{a character string defining the criterion used to select
variables and FP models of different degrees.}
}
\value{
Dataframe with overview of all fp terms. Each row represents a variable,
with rownames giving the name of the variable. Variables with acd
transformation are prefixed by \code{A_} by the \code{print} and \code{summary} methods.
The dataframe comprises the following columns:
\itemize{
\item \code{df_initial}: initial degrees of freedom.
\item \code{select}: significance level for backward elimination.
\item \code{alpha}: significance level for fractional polyomial terms.
\item \code{selected}: logical value encoding presence in the model.
\item \code{df_final}: final estimated degrees of freedom.
\item \code{acd}: logical value encoding use of ACD transformation.
\item \code{powerN}: one or more columns with the final estimated fp powers (numbered
1 to N).
}
}
\description{
To be used in \code{\link[=fit_mfp]{fit_mfp()}}.
}
