% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npSurv2_plots.R
\name{plotnpSurv2.3D}
\alias{plotnpSurv2.3D}
\title{Uses a 3D perspective plot to visualize a nonparametric bivariate
survival function}
\usage{
plotnpSurv2.3D(
  npSurv2.obj,
  col = "grey",
  shade = 0.25,
  theta = 120,
  xlab = "T1",
  ylab = "T2",
  zlab = "Fhat",
  ...
)
}
\arguments{
\item{npSurv2.obj}{Output of the npSurv2 function.}

\item{col}{Color palette to be used for the plot. Defaults to "grey".
See persp3D.}

\item{shade}{The degree of shading of the surface facets. Defaults to
0.25. See persp.}

\item{theta}{The azimuthal viewing direction. See persp.}

\item{xlab}{The x-axis label. Defaults to "T1".}

\item{ylab}{The y-axis label. Defaults to "T2".}

\item{zlab}{The z-axis label. Defaults to "Fhat".}

\item{...}{Additional parameters to the persp3D function.}
}
\description{
Plots a 3D perspective plot of an estimated nonparametric bivariate
survival function. This function is a wrapper for the persp3D function
from the plot3D package with default parameters chosen to make the
data easier to visualize.
}
\examples{
x <- genClayton2(100, 0, 1, 1, 2, 2)
x.npSurv2 <- npSurv2(x$Y1, x$Y2, x$Delta1, x$Delta2)
plotnpSurv2.3D(x.npSurv2)

x2 <- genClayton2(100, 2, 1, 1, 2, 2)
x2.npSurv2 <- npSurv2(x2$Y1, x2$Y2, x2$Delta1, x2$Delta2)
plotnpSurv2.3D(x2.npSurv2)
}
\seealso{
\code{\link{npSurv2}}, \code{\link[plot3D]{persp3D}}
}
