% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_example_filename.R
\name{get_example_filename}
\alias{get_example_filename}
\title{Get the full path to an MHCnuggets example file}
\usage{
get_example_filename(
  filename = "test_peptides.peps",
  folder_name = get_default_mhcnuggets_folder(),
  mhcnuggets_url = get_mhcnuggets_url()
)
}
\arguments{
\item{filename}{name of the example file, without the path}

\item{folder_name}{superfolder of MHCnuggets.
The name of the superfolder is \code{/home/[user_name]/.local/share}
by default, as can be obtained by\link{get_default_mhcnuggets_folder}}

\item{mhcnuggets_url}{URL to the MHCnuggets GitHub repository}
}
\value{
the full path to an MHCnuggets example file
}
\description{
Get the full path to an MHCnuggets example file
}
\examples{
if (is_mhcnuggets_installed()) {
  get_example_filename("test_peptides.peps")
}
}
\seealso{
use \link{get_example_filenames} to get all MHCnuggets
example filenames
}
\author{
Richèl J.C. Bilderbeek
}
