% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.variables.R
\name{mica.variables}
\alias{mica.variables}
\title{Get the variables}
\usage{
mica.variables(
  mica,
  query = "variable()",
  select = list("*"),
  sort = list("id"),
  from = 0,
  limit = 10000,
  locale = "en",
  df = TRUE
)
}
\arguments{
\item{mica}{A Mica object}

\item{query}{The search query}

\item{select}{The fields to be extracted}

\item{sort}{The fields to sort by}

\item{from}{From item}

\item{limit}{Max number of items}

\item{locale}{The language for labels (default is "en")}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the variables
}
\examples{
\dontrun{
m <- mica.login("https://mica-demo.obiba.org")
mica.variables(m, query="variable(in(Mlstr_area.Lifestyle_behaviours,Drugs))")
mica.logout(m)
}
}
