% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmi.R
\name{checkMI}
\alias{checkMI}
\title{Inspect multiple imputation model}
\usage{
checkMI(dep, preds, r_dep, mdag)
}
\arguments{
\item{dep}{The partially observed variable to be imputed, specified as a
string}

\item{preds}{The imputation model predictor(s), specified as a string (space
delimited)}

\item{r_dep}{The partially observed variable's missingness indicator,
specified as a string}

\item{mdag}{The DAG, specified as a string using \link[dagitty]{dagitty}
syntax}
}
\value{
A message indicating whether multiple imputation is valid under the
proposed DAG and imputation model
}
\description{
Check multiple imputation is valid under the proposed imputation model and
directed acyclic graph (DAG). Validity means that the proposed approach will
allow unbiased estimation of the estimand(s) of interest, including
regression parameters, associations, and causal effects. The imputation model
should include all other analysis model variables as predictors, as well as
any auxiliary variables. The DAG should include all observed and unobserved
variables related to the analysis model variables and their missingness, as
well as all required missingness indicators.
}
\details{
In principle, multiple imputation is valid if each partially observed
variable is unrelated to its own missingness, given its imputation model
predictors.
}
\examples{
# Example DAG for which multiple imputation is valid
checkMI(dep="bmi7", preds="matage mated pregsize", r_dep="r",
        mdag="matage -> bmi7 mated -> matage mated -> bmi7
              sep_unmeas -> mated sep_unmeas -> r pregsize -> bmi7
              pregsize -> bwt sep_unmeas -> bwt")

# Example DAG for which multiple imputation is not valid, due to a collider
checkMI(dep="bmi7", preds="matage mated bwt", r_dep="r",
        mdag="matage -> bmi7 mated -> matage mated -> bmi7
              sep_unmeas -> mated sep_unmeas -> r pregsize -> bmi7
              pregsize -> bwt sep_unmeas -> bwt")
}
\references{
Curnow E, Tilling K, Heron JE, Cornish RP, Carpenter JR. 2023.
Multiple imputation of missing data under missing at random: including a
collider as an auxiliary variable in the imputation model can induce bias.
Frontiers in Epidemiology. \url{doi:10.3389/fepid.2023.1237447}
}
