% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{beta_mean}
\alias{beta_mean}
\title{LNM Posterior Mean}
\usage{
beta_mean(fit)
}
\arguments{
\item{fit}{An object of class \code{lnm} whose estimate slot contains the 'rstan'
fitted logistic normal multinomial model.}
}
\value{
A matrix whose rows are predictors and columns are outcomes in the
beta parameter for the LNM model.
}
\description{
Average the samples for the beta parameter from the VB posterior mean. This
is used to get predicted compositions when using \code{predict} on an lnm model.
}
\examples{
example_data <- lnm_data(N = 50, K = 10)
xy <- dplyr::bind_cols(example_data[c("X", "y")])
fit <- lnm(
    starts_with("y") ~ starts_with("x"), xy, 
    iter = 25, output_samples = 25
)
beta_mean(fit)
}
